( function ( blocks, element, blockEditor, i18n ) {
	const { registerBlockType } = blocks;
	const { createElement: el } = element;
	const { InnerBlocks } = blockEditor;
	const __ = i18n.__;

	registerBlockType( 'hubwright/gated-content', {
		title: 'hubWright Gated Content',
		icon: 'lock',
		category: 'widgets',
		description: 'Show this section only to logged-in readers when the hubWright paywall is enabled.',
		supports: {
			html: false,
		},
		edit: () =>
			el(
				'div',
				{
					style: {
						border: '1px dashed #cbd5e1',
						padding: '12px',
						borderRadius: '6px',
					},
				},
				el(
					'p',
					{ style: { marginTop: 0, fontWeight: 600 } },
					__('Gated content (hubWright)', 'hubwright')
				),
				el(
					'p',
					{ style: { marginTop: 0, color: '#475569' } },
					__('Only logged-in users see this when paywall is on.', 'hubwright')
				),
				el( InnerBlocks )
			),
		save: () => el( InnerBlocks.Content ),
	} );
} )( window.wp.blocks, window.wp.element, window.wp.blockEditor || window.wp.editor, window.wp.i18n );
