# hubWright (WP plugin scaffold)

Minimal WordPress plugin that connects sites to the collective hub, syncs published posts, and renders a reader bar shell.

## Features (MVP)
- Admin settings page: hub URL, site key, site secret, toggle sync.
- Issues a short-lived JWT for the current user at `wp-json/hw/v1/token` (HMAC-based placeholder; swap in real JWT signing).
- Hooks post publish to send post metadata to the hub at `/v1/content/ingest` with HMAC header.
- Enqueues a lightweight reader bar shell (no placeholder content block by default).
- Exposes `hw/v1/push-update` to receive hub-triggered plugin updates (HMAC with site secret), backs up the current version, and deploys the new package.

## Next steps
1. Replace the placeholder JWT signer with a vetted JWT library (or server-side signer that uses an asymmetric keypair).
2. Build the SPA for the Reader Bar and Reader page that calls the hub endpoints.
3. Flesh out error handling + admin test-connection button.
4. Add follow/save buttons to post templates (call hub `/follow` and `/save`).
5. Map topics to a dedicated taxonomy if you prefer not to reuse categories/tags.
